<?php
header("Content-Type: application/json");

// Input JSON डेटा प्राप्त करें
$inputJSON = file_get_contents("php://input");
$inputData = json_decode($inputJSON, true);

// Authorization Token Check (Optional)
$headers = getallheaders();
$authHeader = isset($headers['Authorization']) ? $headers['Authorization'] : null;

// Validate Authorization Token (Basic Check)
if (!$authHeader || strpos($authHeader, 'Bearer ') !== 0) {
    echo json_encode(["code" => 401, "msg" => "Unauthorized"]);
    exit;
}

// Sample User Balance Data (डेटाबेस से भी लाया जा सकता है)
$userBalance = 30.00;
$amountOfCode = 30.00;

// JSON Response
$response = [
    "data" => [
        "balance" => $userBalance,
        "amountOfCode" => $amountOfCode
    ],
    "code" => 0,
    "msg" => "Succeed",
    "msgCode" => 0,
    "serviceNowTime" => date("Y-m-d H:i:s")
];

echo json_encode($response);
?>