<?php 
	include "../../conn.php";
	include "../../functions2.php";

	header('Content-Type: application/json; charset=utf-8');
	header('Strict-Transport-Security: max-age=31536000');
	header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
	header('Access-Control-Allow-Credentials: true');
	$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
	header('Access-Control-Allow-Origin: ' . $origin);
	header('vary: Origin');

	date_default_timezone_set('Asia/Kolkata');
	$shnunc = date("Y-m-d H:i:s");
	$res = [
		'code' => 11,
		'msg' => 'Method not allowed',
		'msgCode' => 12,
		'serviceNowTime' => $shnunc,
	];
	$shonubody = file_get_contents("php://input");
	$shonupost = json_decode($shonubody, true);

	if ($_SERVER['REQUEST_METHOD'] != 'GET') {
		if (isset($shonupost['language']) || isset($shonupost['payTypeId']) || isset($shonupost['payid']) || isset($shonupost['random']) || isset($shonupost['signature']) || isset($shonupost['timestamp'])) {
			$language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
			$payTypeId = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['payTypeId']));
			$payid = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['payid']));
			$random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
			$signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature']));
			$shonustr = '{"language":'.$language.',"payTypeId":'.$payTypeId.',"payid":'.$payid.',"random":"'.$random.'"}';
			$shonusign = strtoupper(md5($shonustr));

			if($shonusign){
				$bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
				$author = $bearer[1];
				$is_jwt_valid = is_jwt_valid($author);
				$data_auth = json_decode($is_jwt_valid, 1);

				if($data_auth['status'] === 'Success') {
					$sesquery = "SELECT akshinak FROM shonu_subjects WHERE akshinak = '$author'";
					$sesresult = $conn->query($sesquery);
					$sesnum = mysqli_num_rows($sesresult);

					if($sesnum == 1){
						$sites = 'https://bluewin.sbs';

						$minRechargeQuery = "SELECT min_recharge FROM web_setting LIMIT 1";
						$minRechargeResult = $conn->query($minRechargeQuery);
						$amount = 0;
						if ($minRechargeResult && $minRechargeResult->num_rows > 0) {
							$row = $minRechargeResult->fetch_assoc();
							$amount = $row['min_recharge'];
						}

						// Fetch payment methods by payid
						$rechargetypelist = [];
						$sql = "SELECT * FROM payment_methods WHERE payID = '$payid' AND status = 'active' ORDER BY id ASC";
						$result = $conn->query($sql);

						if ($result && $result->num_rows > 0) {
							while ($row = $result->fetch_assoc()) {
								$scopeValues = explode('|', $row['scope']);
								$quickConfigList = [];
								foreach ($scopeValues as $val) {
									$quickConfigList[] = [
										"rechargeAmount" => (float)$val,
										"giftAmount" => 0.0
									];
								}
								$rechargetypelist[] = [
									"payTypeID" => (int)$row['payTypeID'],
									"payID" => (int)$row['payID'],
									"payName" => $row['payName'],
									"paySysName" => $row['paySysName'],
									"miniPrice" => (float)$row['miniPrice'],
									"maxPrice" => (float)$row['maxPrice'],
									"scope" => $row['scope'],
									"paySendUrl" => $row['paySendUrl'],
									"parameters" => $row['parameters'] ?? '',
									"startTime" => $row['startTime'],
									"endTime" => $row['endTime'],
									"rechargeRifts" => (float)$row['rechargeRifts'],
									"c2cUnitAmount" => isset($row['c2cUnitAmount']) ? (float)$row['c2cUnitAmount'] : null,
									"quickConfig" => "",
									"quickConfigList" => $quickConfigList,
									"random" => (float)mt_rand() / mt_getrandmax(),
									"sort" => 90000
								];
							}
						}

						$data['rechargetypelist'] = $rechargetypelist;
						$data['banklist'] = null;
						$data['localUsdtlist'] = null;
						$data['thirdPayBankList'] = null;
						$data['minRechargeAmount'] = $amount;

						$res['data'] = $data;
						$res['code'] = 0;
						$res['msg'] = 'Succeed';
						$res['msgCode'] = 0;
						http_response_code(200);
						echo json_encode($res);
						exit;
					}
					else{
						$res['code'] = 4;
						$res['msg'] = 'No operation permission';
						$res['msgCode'] = 2;
						http_response_code(401);
						echo json_encode($res);
						exit;
					}
				}
				else{
					$res['code'] = 4;
					$res['msg'] = 'Invalid JWT';
					$res['msgCode'] = 2;
					http_response_code(401);
					echo json_encode($res);
					exit;
				}
			}
			else{
				$res['code'] = 5;
				$res['msg'] = 'Wrong signature';
				$res['msgCode'] = 3;
				http_response_code(200);
				echo json_encode($res);
				exit;
			}
		}
		else{
			$res['code'] = 7;
			$res['msg'] = 'Param is Invalid';
			$res['msgCode'] = 6;
			http_response_code(200);
			echo json_encode($res);
			exit;
		}
	} else {
		http_response_code(405);
		echo json_encode($res);
		exit;
	}
?>