<?php 
	include "../../conn.php";

	header('Content-Type: application/json; charset=utf-8');
	header('Strict-Transport-Security: max-age=31536000');
	header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
	header('Access-Control-Allow-Credentials: true');
	$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
	header('Access-Control-Allow-Origin: ' . $origin);
	header('vary: Origin');
	
	date_default_timezone_set('Asia/Kolkata');
	$shnunc = date("Y-m-d H:i:s");
	$res = [
		'code' => 11,
		'msg' => 'Method not allowed',
		'msgCode' => 12,
		'serviceNowTime' => $shnunc,
	];
	$shonubody = file_get_contents("php://input");
	$shonupost = json_decode($shonubody, true);
	if ($_SERVER['REQUEST_METHOD'] != 'GET') {
		if (isset($shonupost['language']) && isset($shonupost['random']) && isset($shonupost['signature']) && isset($shonupost['timestamp'])) {
			$language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
			$random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
			$signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature']));
			$shonustr = '{"language":'.$language.',"random":"'.$random.'"}';
			$shonusign = strtoupper(md5($shonustr));
			if($shonusign == $signature){
				http_response_code(200);
				echo '{
				  "data": {
					"dataList": [
					  {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "15",
                "nickName": "MemberSUSFQYCW",
                "betAmount": 600.00,
                "amount": 1176.00,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "17",
                "nickName": "MemberAMYKRQFW",
                "betAmount": 100.00,
                "amount": 196.00,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "8",
                "nickName": "MemberXBPSGMFN",
                "betAmount": 1000.00,
                "amount": 1960.00,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "18",
                "nickName": "MemberADQTKOXR",
                "betAmount": 300.00,
                "amount": 588.00,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "9",
                "nickName": "MemberJTZSUGIT",
                "betAmount": 500.00,
                "amount": 980.00,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "14",
                "nickName": "MemberYAIGGCUT",
                "betAmount": 80.00,
                "amount": 156.80,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "10",
                "nickName": "MemberZQXBJDOH",
                "betAmount": 200.00,
                "amount": 392.00,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "5",
                "nickName": "MemberNLQQMMOP",
                "betAmount": 1000.00,
                "amount": 1960.00,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "15",
                "nickName": "MemberXKWPLHJY",
                "betAmount": 2000.00,
                "amount": 2940.00,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "11",
                "nickName": "MemberHOVNUXYN",
                "betAmount": 300.00,
                "amount": 588.00,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "12",
                "nickName": "MemberHSNGNGFK",
                "betAmount": 500.00,
                "amount": 980.00,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "15",
                "nickName": "MemberFREVCNGZ",
                "betAmount": 100.00,
                "amount": 196.00,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "19",
                "nickName": "MemberQNSNJDDA",
                "betAmount": 88.00,
                "amount": 172.48,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "9",
                "nickName": "MemberLIAJODZG",
                "betAmount": 5000.00,
                "amount": 9800.00,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "7",
                "nickName": "MemberPBDVHYQN",
                "betAmount": 90.00,
                "amount": 176.40,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "10",
                "nickName": "MemberNSJCYZKD",
                "betAmount": 100.00,
                "amount": 196.00,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "14",
                "nickName": "MemberQNITOGOF",
                "betAmount": 100.00,
                "amount": 196.00,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "6",
                "nickName": "MemberHQIZYXTX",
                "betAmount": 20.00,
                "amount": 176.40,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "9",
                "nickName": "MemberFSEITHLV",
                "betAmount": 400.00,
                "amount": 784.00,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "30",
                "typeName": "WinGo 30 sec",
                "userPhoto": "11",
                "nickName": "MemberHLEMQJSR",
                "betAmount": 190.00,
                "amount": 372.40,
                "winTime": "2025-09-24 10:39:27",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "5",
                "typeName": "5D 1 min",
                "userPhoto": "17",
                "nickName": "MemberZZUUMCHP",
                "betAmount": 1800.00,
                "amount": 3528.00,
                "winTime": "2025-09-24 10:38:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "5",
                "typeName": "5D 1 min",
                "userPhoto": "13",
                "nickName": "MemberECZSRYJX",
                "betAmount": 60.00,
                "amount": 117.60,
                "winTime": "2025-09-24 10:38:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "17",
                "nickName": "MemberTYYCHSPA",
                "betAmount": 1960.00,
                "amount": 3920.00,
                "winTime": "2025-09-24 10:38:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "10",
                "typeName": "K3 3 min",
                "userPhoto": "18",
                "nickName": "MemberQECTJGKT",
                "betAmount": 98.00,
                "amount": 196.00,
                "winTime": "2025-09-24 10:38:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "19",
                "nickName": "MemberMHDELRQP",
                "betAmount": 959.42,
                "amount": 1918.84,
                "winTime": "2025-09-24 10:38:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "4",
                "nickName": "MemberJEPIJYSY",
                "betAmount": 196.00,
                "amount": 392.00,
                "winTime": "2025-09-24 10:38:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "3",
                "nickName": "MemberCWRAKQPB",
                "betAmount": 98.98,
                "amount": 197.96,
                "winTime": "2025-09-24 10:38:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "11",
                "nickName": "MemberEMXQYSMU",
                "betAmount": 98.00,
                "amount": 338.83,
                "winTime": "2025-09-24 10:38:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "17",
                "nickName": "MemberMPCNSHUK",
                "betAmount": 88.20,
                "amount": 176.40,
                "winTime": "2025-09-24 10:38:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "19",
                "nickName": "MemberWBQUXKLX",
                "betAmount": 88.20,
                "amount": 176.40,
                "winTime": "2025-09-24 10:38:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "18",
                "nickName": "MemberTEMMOKMW",
                "betAmount": 294.00,
                "amount": 588.00,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "1",
                "nickName": "MemberIMUWWCIV",
                "betAmount": 324.38,
                "amount": 648.76,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "1",
                "nickName": "MemberDWVXGIDV",
                "betAmount": 490.00,
                "amount": 980.00,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "18",
                "nickName": "MemberTGPARAKG",
                "betAmount": 392.00,
                "amount": 784.00,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "7",
                "nickName": "MemberGRBWPSUG",
                "betAmount": 98.00,
                "amount": 196.00,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "13",
                "nickName": "MemberYBSUQGBX",
                "betAmount": 980.00,
                "amount": 1960.00,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "13",
                "nickName": "MemberOHFEJIXB",
                "betAmount": 490.00,
                "amount": 980.00,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "17",
                "nickName": "MemberIRLBFTCB",
                "betAmount": 98.00,
                "amount": 196.00,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "14",
                "nickName": "MemberJRCEDTPB",
                "betAmount": 186.20,
                "amount": 372.40,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "9",
                "nickName": "MemberRNMSHVPU",
                "betAmount": 98.00,
                "amount": 196.00,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "1",
                "nickName": "MemberRCZWLZFL",
                "betAmount": 392.00,
                "amount": 784.00,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "15",
                "nickName": "MemberMKGVFEGB",
                "betAmount": 98.00,
                "amount": 196.00,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "18",
                "nickName": "MemberHNTVFERE",
                "betAmount": 98.00,
                "amount": 196.00,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "2",
                "nickName": "MemberIMYRMNKK",
                "betAmount": 245.00,
                "amount": 490.00,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "10",
                "nickName": "MemberBJADXGTK",
                "betAmount": 196.00,
                "amount": 392.00,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "7",
                "nickName": "MemberPXFGBHTD",
                "betAmount": 294.00,
                "amount": 588.00,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "6",
                "nickName": "MemberICMPRXCH",
                "betAmount": 98.00,
                "amount": 196.00,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "10",
                "nickName": "MemberKTUTBPMA",
                "betAmount": 588.00,
                "amount": 1176.00,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "17",
                "nickName": "MemberAYYWCATE",
                "betAmount": 294.00,
                "amount": 588.00,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "13",
                "typeName": "TrxWin 1 min",
                "userPhoto": "9",
                "nickName": "MemberIGZUTVVU",
                "betAmount": 176.40,
                "amount": 352.80,
                "winTime": "2025-09-24 10:38:55",
                "showType": 8,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062124qut6.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "13",
                "nickName": "MemberQLHOTBCX",
                "betAmount": 50.00,
                "amount": 200.00,
                "winTime": "2025-09-24 10:38:20",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "SPRIBE",
                "typeName": "SPRIBE",
                "userPhoto": "4",
                "nickName": "MemberZOUKVVLV",
                "betAmount": 100.00,
                "amount": 221.00,
                "winTime": "2025-09-24 10:38:19",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "19",
                "nickName": "MemberIHSENDOB",
                "betAmount": 5.00,
                "amount": 151.00,
                "winTime": "2025-09-24 10:38:19",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "12",
                "nickName": "MemberFGLVTKVY",
                "betAmount": 90.00,
                "amount": 900.00,
                "winTime": "2025-09-24 10:38:19",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JDB",
                "typeName": "JDB",
                "userPhoto": "14",
                "nickName": "MemberBAZOEOUH",
                "betAmount": 20.00,
                "amount": 200.00,
                "winTime": "2025-09-24 10:38:19",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062430212b.png"
            },
            {
                "type": "SPRIBE",
                "typeName": "SPRIBE",
                "userPhoto": "9",
                "nickName": "MemberACCAGRYD",
                "betAmount": 50.00,
                "amount": 105.50,
                "winTime": "2025-09-24 10:38:18",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG"
            },
            {
                "type": "SPRIBE",
                "typeName": "SPRIBE",
                "userPhoto": "11",
                "nickName": "MemberVGYXUEZF",
                "betAmount": 100.00,
                "amount": 209.00,
                "winTime": "2025-09-24 10:38:18",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG"
            },
            {
                "type": "SPRIBE",
                "typeName": "SPRIBE",
                "userPhoto": "2",
                "nickName": "MemberTMQCKEKB",
                "betAmount": 500.00,
                "amount": 3903.09,
                "winTime": "2025-09-24 10:38:18",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG"
            },
            {
                "type": "SPRIBE",
                "typeName": "SPRIBE",
                "userPhoto": "15",
                "nickName": "MemberSXPOWFPO",
                "betAmount": 300.00,
                "amount": 600.00,
                "winTime": "2025-09-24 10:38:18",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG"
            },
            {
                "type": "SPRIBE",
                "typeName": "SPRIBE",
                "userPhoto": "15",
                "nickName": "MemberUSJVBIAO",
                "betAmount": 100.00,
                "amount": 200.00,
                "winTime": "2025-09-24 10:38:18",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG"
            },
            {
                "type": "SPRIBE",
                "typeName": "SPRIBE",
                "userPhoto": "7",
                "nickName": "MemberVPEANTWO",
                "betAmount": 75.00,
                "amount": 147.75,
                "winTime": "2025-09-24 10:38:18",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "14",
                "nickName": "MemberWTTUXGKX",
                "betAmount": 100.00,
                "amount": 511.00,
                "winTime": "2025-09-24 10:38:18",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "19",
                "nickName": "MemberWHPOJUJQ",
                "betAmount": 4.50,
                "amount": 360.00,
                "winTime": "2025-09-24 10:38:18",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "15",
                "nickName": "MemberRQAMBNKN",
                "betAmount": 30.00,
                "amount": 288.00,
                "winTime": "2025-09-24 10:38:18",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "1",
                "nickName": "MemberSGOUHLMM",
                "betAmount": 100.00,
                "amount": 126.00,
                "winTime": "2025-09-24 10:38:18",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "TB_Chess",
                "typeName": "TB_Chess",
                "userPhoto": "8",
                "nickName": "MemberINEMEUQY",
                "betAmount": 130.00,
                "amount": 224.17,
                "winTime": "2025-09-24 10:38:18",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062327hld7.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "7",
                "nickName": "MemberFIYLOXFK",
                "betAmount": 100.00,
                "amount": 110.00,
                "winTime": "2025-09-24 10:38:17",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "12",
                "nickName": "MemberGRQHCIZW",
                "betAmount": 90.00,
                "amount": 300.00,
                "winTime": "2025-09-24 10:38:17",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "13",
                "nickName": "MemberRVUGQBLV",
                "betAmount": 10.00,
                "amount": 150.00,
                "winTime": "2025-09-24 10:38:17",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "2",
                "nickName": "MemberWNMELBBC",
                "betAmount": 1.00,
                "amount": 120.00,
                "winTime": "2025-09-24 10:38:17",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "7",
                "nickName": "MemberWBHNNWHR",
                "betAmount": 1100.00,
                "amount": 2000.00,
                "winTime": "2025-09-24 10:38:17",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "9",
                "nickName": "MemberNLRUPSEF",
                "betAmount": 17.00,
                "amount": 160.00,
                "winTime": "2025-09-24 10:38:17",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "2",
                "nickName": "MemberSYQOGQCP",
                "betAmount": 768.00,
                "amount": 2700.00,
                "winTime": "2025-09-24 10:38:17",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "TB_Chess",
                "typeName": "TB_Chess",
                "userPhoto": "2",
                "nickName": "MemberTCLGKGTR",
                "betAmount": 500.00,
                "amount": 1290.00,
                "winTime": "2025-09-24 10:38:17",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062327hld7.png"
            },
            {
                "type": "SPRIBE",
                "typeName": "SPRIBE",
                "userPhoto": "8",
                "nickName": "MemberJKTWLEDM",
                "betAmount": 200.00,
                "amount": 334.00,
                "winTime": "2025-09-24 10:38:16",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "16",
                "nickName": "MemberLAJTXKAD",
                "betAmount": 10.00,
                "amount": 555.00,
                "winTime": "2025-09-24 10:38:16",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "18",
                "nickName": "MemberUNRHZVOR",
                "betAmount": 90.00,
                "amount": 300.00,
                "winTime": "2025-09-24 10:38:16",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "3",
                "nickName": "MemberZYOOCKHM",
                "betAmount": 200.00,
                "amount": 200.00,
                "winTime": "2025-09-24 10:38:16",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "TB_Chess",
                "typeName": "TB_Chess",
                "userPhoto": "10",
                "nickName": "MemberEYRPUHZL",
                "betAmount": 20.00,
                "amount": 1394.00,
                "winTime": "2025-09-24 10:38:16",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062327hld7.png"
            },
            {
                "type": "TB_Chess",
                "typeName": "TB_Chess",
                "userPhoto": "18",
                "nickName": "MemberYCPFQNDV",
                "betAmount": 100.00,
                "amount": 735.00,
                "winTime": "2025-09-24 10:38:16",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062327hld7.png"
            },
            {
                "type": "SPRIBE",
                "typeName": "SPRIBE",
                "userPhoto": "6",
                "nickName": "MemberLCMQLMZF",
                "betAmount": 28.80,
                "amount": 292.05,
                "winTime": "2025-09-24 10:38:15",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG"
            },
            {
                "type": "SPRIBE",
                "typeName": "SPRIBE",
                "userPhoto": "9",
                "nickName": "MemberTNZPRSJH",
                "betAmount": 200.00,
                "amount": 312.00,
                "winTime": "2025-09-24 10:38:15",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "4",
                "nickName": "MemberIKUCDOKA",
                "betAmount": 10.00,
                "amount": 180.00,
                "winTime": "2025-09-24 10:38:15",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "14",
                "nickName": "MemberJSXNRJXU",
                "betAmount": 40.00,
                "amount": 120.00,
                "winTime": "2025-09-24 10:38:15",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "15",
                "nickName": "MemberZLDAFHBK",
                "betAmount": 50.00,
                "amount": 750.00,
                "winTime": "2025-09-24 10:38:15",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "15",
                "nickName": "MemberIHYEUZRM",
                "betAmount": 960.00,
                "amount": 3600.00,
                "winTime": "2025-09-24 10:38:15",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "19",
                "nickName": "MemberVAKVCPDX",
                "betAmount": 168.00,
                "amount": 540.00,
                "winTime": "2025-09-24 10:38:15",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JDB",
                "typeName": "JDB",
                "userPhoto": "11",
                "nickName": "MemberOOWSJJIE",
                "betAmount": 30.00,
                "amount": 154.00,
                "winTime": "2025-09-24 10:38:15",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062430212b.png"
            },
            {
                "type": "TB_Chess",
                "typeName": "TB_Chess",
                "userPhoto": "10",
                "nickName": "MemberSCHDEVIB",
                "betAmount": 50.00,
                "amount": 397.50,
                "winTime": "2025-09-24 10:38:15",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062327hld7.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "17",
                "nickName": "MemberVRZJANBQ",
                "betAmount": 50.00,
                "amount": 1200.00,
                "winTime": "2025-09-24 10:38:14",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "18",
                "nickName": "MemberASVFFNID",
                "betAmount": 100.00,
                "amount": 2000.00,
                "winTime": "2025-09-24 10:38:13",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "8",
                "nickName": "MemberLPQKXQXM",
                "betAmount": 90.00,
                "amount": 600.00,
                "winTime": "2025-09-24 10:38:13",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JDB",
                "typeName": "JDB",
                "userPhoto": "7",
                "nickName": "MemberWPMHKXKD",
                "betAmount": 3.00,
                "amount": 146.40,
                "winTime": "2025-09-24 10:38:13",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062430212b.png"
            },
            {
                "type": "SPRIBE",
                "typeName": "SPRIBE",
                "userPhoto": "14",
                "nickName": "MemberAWSCIZAZ",
                "betAmount": 100.00,
                "amount": 126.00,
                "winTime": "2025-09-24 10:38:12",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "1",
                "nickName": "MemberVTBQXUMB",
                "betAmount": 100.00,
                "amount": 110.00,
                "winTime": "2025-09-24 10:38:12",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "12",
                "nickName": "MemberFQXIBRDK",
                "betAmount": 30.00,
                "amount": 2109.00,
                "winTime": "2025-09-24 10:38:12",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "5",
                "nickName": "MemberTUIZNMBE",
                "betAmount": 5.00,
                "amount": 120.00,
                "winTime": "2025-09-24 10:38:12",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "TB_Chess",
                "typeName": "TB_Chess",
                "userPhoto": "9",
                "nickName": "MemberNLAZRDPI",
                "betAmount": 8.00,
                "amount": 239.20,
                "winTime": "2025-09-24 10:38:12",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062327hld7.png"
            },
            {
                "type": "TB_Chess",
                "typeName": "TB_Chess",
                "userPhoto": "11",
                "nickName": "MemberQREPGSUP",
                "betAmount": 50.00,
                "amount": 462.50,
                "winTime": "2025-09-24 10:38:12",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062327hld7.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "4",
                "nickName": "MemberUSXZCUXZ",
                "betAmount": 5.00,
                "amount": 214.50,
                "winTime": "2025-09-24 10:38:11",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "8",
                "nickName": "MemberTNBVIPAC",
                "betAmount": 20.00,
                "amount": 164.00,
                "winTime": "2025-09-24 10:38:11",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "6",
                "nickName": "MemberCSHQGYVS",
                "betAmount": 80.00,
                "amount": 240.00,
                "winTime": "2025-09-24 10:38:11",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "8",
                "nickName": "MemberABLHWCJX",
                "betAmount": 100.00,
                "amount": 600.00,
                "winTime": "2025-09-24 10:38:11",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "3",
                "nickName": "MemberBJAPVCBQ",
                "betAmount": 54.00,
                "amount": 120.00,
                "winTime": "2025-09-24 10:38:11",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "9",
                "nickName": "MemberWHCJNVAW",
                "betAmount": 90.00,
                "amount": 120.00,
                "winTime": "2025-09-24 10:38:10",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "8",
                "nickName": "MemberCFGUDDAS",
                "betAmount": 100.00,
                "amount": 200.00,
                "winTime": "2025-09-24 10:38:10",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "3",
                "nickName": "MemberGRBGSEWF",
                "betAmount": 12.00,
                "amount": 216.00,
                "winTime": "2025-09-24 10:38:10",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "9",
                "nickName": "MemberUOBRRAJT",
                "betAmount": 1860.00,
                "amount": 3000.00,
                "winTime": "2025-09-24 10:38:10",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "TB_Chess",
                "typeName": "TB_Chess",
                "userPhoto": "11",
                "nickName": "MemberTKCFCAGL",
                "betAmount": 10.00,
                "amount": 108.60,
                "winTime": "2025-09-24 10:38:10",
                "showType": 6,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062327hld7.png"
            },
            {
                "type": "MG",
                "typeName": "MG",
                "userPhoto": "2",
                "nickName": "MemberDQMEDJLR",
                "betAmount": 30.00,
                "amount": 150.00,
                "winTime": "2025-09-24 10:38:09",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_2024011006235271p9.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "6",
                "nickName": "MemberCLILRNGT",
                "betAmount": 100.00,
                "amount": 2000.00,
                "winTime": "2025-09-24 10:38:09",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "7",
                "nickName": "MemberRWQOZPVQ",
                "betAmount": 2280.00,
                "amount": 4500.00,
                "winTime": "2025-09-24 10:38:09",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JDB",
                "typeName": "JDB",
                "userPhoto": "17",
                "nickName": "MemberHDWMNAVP",
                "betAmount": 30.00,
                "amount": 200.00,
                "winTime": "2025-09-24 10:38:09",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062430212b.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "6",
                "nickName": "MemberQINZMPVO",
                "betAmount": 10.00,
                "amount": 110.00,
                "winTime": "2025-09-24 10:38:08",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "19",
                "nickName": "MemberMRBRWMCP",
                "betAmount": 10.00,
                "amount": 160.00,
                "winTime": "2025-09-24 10:38:08",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "13",
                "nickName": "MemberAOTYIVWL",
                "betAmount": 50.00,
                "amount": 260.00,
                "winTime": "2025-09-24 10:38:08",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "14",
                "nickName": "MemberYAETIWNO",
                "betAmount": 30.00,
                "amount": 120.00,
                "winTime": "2025-09-24 10:38:08",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "8",
                "nickName": "MemberWCDWSODB",
                "betAmount": 5.00,
                "amount": 200.00,
                "winTime": "2025-09-24 10:38:08",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "14",
                "nickName": "MemberUYWNEMJN",
                "betAmount": 30.00,
                "amount": 120.00,
                "winTime": "2025-09-24 10:38:08",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "1",
                "nickName": "MemberEINIIZMU",
                "betAmount": 100.00,
                "amount": 510.00,
                "winTime": "2025-09-24 10:38:07",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "6",
                "nickName": "MemberJTPWUWKJ",
                "betAmount": 50.00,
                "amount": 250.00,
                "winTime": "2025-09-24 10:38:07",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "3",
                "nickName": "MemberEHCZKSAI",
                "betAmount": 5.00,
                "amount": 105.00,
                "winTime": "2025-09-24 10:38:07",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "11",
                "nickName": "MemberAPDYFXQO",
                "betAmount": 3.00,
                "amount": 120.00,
                "winTime": "2025-09-24 10:38:07",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "19",
                "nickName": "MemberTAHNWUID",
                "betAmount": 10.00,
                "amount": 500.00,
                "winTime": "2025-09-24 10:38:07",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "9",
                "nickName": "MemberJIAAIZGQ",
                "betAmount": 150.00,
                "amount": 300.00,
                "winTime": "2025-09-24 10:38:07",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "19",
                "nickName": "MemberGYEVCLGK",
                "betAmount": 200.00,
                "amount": 500.00,
                "winTime": "2025-09-24 10:38:07",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "3",
                "nickName": "MemberOGDQQZSQ",
                "betAmount": 2520.00,
                "amount": 7200.00,
                "winTime": "2025-09-24 10:38:07",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "9",
                "nickName": "MemberJRICWICV",
                "betAmount": 7.50,
                "amount": 120.00,
                "winTime": "2025-09-24 10:38:06",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "5",
                "nickName": "MemberQLUKQXSG",
                "betAmount": 5.00,
                "amount": 151.00,
                "winTime": "2025-09-24 10:38:05",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "1",
                "nickName": "MemberBPKUZMWN",
                "betAmount": 100.00,
                "amount": 2000.00,
                "winTime": "2025-09-24 10:38:05",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "7",
                "nickName": "MemberYMEFCHAX",
                "betAmount": 100.00,
                "amount": 111.00,
                "winTime": "2025-09-24 10:38:05",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "16",
                "nickName": "MemberBFPSNGSC",
                "betAmount": 54.00,
                "amount": 160.00,
                "winTime": "2025-09-24 10:38:05",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "7",
                "nickName": "MemberRNVCOLWT",
                "betAmount": 50.00,
                "amount": 250.00,
                "winTime": "2025-09-24 10:38:04",
                "showType": 4,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "2",
                "nickName": "MemberCSUOBVLI",
                "betAmount": 2580.00,
                "amount": 9600.00,
                "winTime": "2025-09-24 10:38:03",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "16",
                "nickName": "MemberVKBJIVHC",
                "betAmount": 122.00,
                "amount": 1440.00,
                "winTime": "2025-09-24 10:38:03",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "11",
                "nickName": "MemberUNHVEBZE",
                "betAmount": 150.00,
                "amount": 150.00,
                "winTime": "2025-09-24 10:38:02",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JDB",
                "typeName": "JDB",
                "userPhoto": "16",
                "nickName": "MemberWNRYITDL",
                "betAmount": 24.00,
                "amount": 210.00,
                "winTime": "2025-09-24 10:38:02",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062430212b.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "6",
                "nickName": "MemberLRNOMOVW",
                "betAmount": 25.00,
                "amount": 600.00,
                "winTime": "2025-09-24 10:38:01",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "8",
                "nickName": "MemberLWOWARMM",
                "betAmount": 54.00,
                "amount": 200.00,
                "winTime": "2025-09-24 10:37:59",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "JILI",
                "typeName": "JILI",
                "userPhoto": "2",
                "nickName": "MemberUVXDRFKI",
                "betAmount": 150.00,
                "amount": 900.00,
                "winTime": "2025-09-24 10:37:57",
                "showType": 5,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062442t4sm.png"
            },
            {
                "type": "5",
                "typeName": "5D 1 min",
                "userPhoto": "5",
                "nickName": "MemberEKPOHVDT",
                "betAmount": 1990.00,
                "amount": 3900.40,
                "winTime": "2025-09-24 10:37:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "3",
                "nickName": "MemberSPJVSEHE",
                "betAmount": 19.60,
                "amount": 169.34,
                "winTime": "2025-09-24 10:37:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "2",
                "nickName": "MemberAXDGKESD",
                "betAmount": 58.80,
                "amount": 117.60,
                "winTime": "2025-09-24 10:37:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "13",
                "nickName": "MemberQGINWQYF",
                "betAmount": 14.70,
                "amount": 169.34,
                "winTime": "2025-09-24 10:37:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "7",
                "nickName": "MemberMCJJKOAU",
                "betAmount": 58.80,
                "amount": 117.60,
                "winTime": "2025-09-24 10:37:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "KoolBet",
                "typeName": "KoolBet",
                "userPhoto": "10",
                "nickName": "MemberBOMXOFBR",
                "betAmount": 100.00,
                "amount": 300.00,
                "winTime": "2025-09-24 10:37:18",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20250830170136ql3l.png"
            },
            {
                "type": "Card365",
                "typeName": "Card365",
                "userPhoto": "7",
                "nickName": "MemberNNERJSSM",
                "betAmount": 562.60,
                "amount": 1142.60,
                "winTime": "2025-09-24 10:37:09",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062223jjaj.png"
            },
            {
                "type": "5",
                "typeName": "5D 1 min",
                "userPhoto": "19",
                "nickName": "MemberHVFSFLRM",
                "betAmount": 2000.00,
                "amount": 3920.00,
                "winTime": "2025-09-24 10:36:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "15",
                "nickName": "MemberGKALVOBH",
                "betAmount": 218.54,
                "amount": 437.08,
                "winTime": "2025-09-24 10:36:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "14",
                "nickName": "MemberMDVAVRVI",
                "betAmount": 67.62,
                "amount": 135.24,
                "winTime": "2025-09-24 10:36:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "KoolBet",
                "typeName": "KoolBet",
                "userPhoto": "6",
                "nickName": "MemberJCIKQBJG",
                "betAmount": 100.00,
                "amount": 242.00,
                "winTime": "2025-09-24 10:36:26",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20250830170136ql3l.png"
            },
            {
                "type": "6",
                "typeName": "5D 3 min",
                "userPhoto": "15",
                "nickName": "MemberGOUMCANP",
                "betAmount": 200.00,
                "amount": 392.00,
                "winTime": "2025-09-24 10:35:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "4",
                "nickName": "MemberUFYTHPQS",
                "betAmount": 637.00,
                "amount": 1274.00,
                "winTime": "2025-09-24 10:35:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "5",
                "typeName": "5D 1 min",
                "userPhoto": "17",
                "nickName": "MemberWXFRAXVZ",
                "betAmount": 2000.00,
                "amount": 3920.00,
                "winTime": "2025-09-24 10:34:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "3",
                "nickName": "MemberYCSUKWQL",
                "betAmount": 98.00,
                "amount": 196.00,
                "winTime": "2025-09-24 10:34:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "11",
                "typeName": "K3 5 min",
                "userPhoto": "11",
                "nickName": "MemberCMKNRAUE",
                "betAmount": 49.00,
                "amount": 406.70,
                "winTime": "2025-09-24 10:34:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "KoolBet",
                "typeName": "KoolBet",
                "userPhoto": "9",
                "nickName": "MemberPOOAGMML",
                "betAmount": 118.00,
                "amount": 318.00,
                "winTime": "2025-09-24 10:34:56",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20250830170136ql3l.png"
            },
            {
                "type": "KoolBet",
                "typeName": "KoolBet",
                "userPhoto": "7",
                "nickName": "MemberTMKTTYKB",
                "betAmount": 84.00,
                "amount": 284.00,
                "winTime": "2025-09-24 10:34:37",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20250830170136ql3l.png"
            },
            {
                "type": "Card365",
                "typeName": "Card365",
                "userPhoto": "14",
                "nickName": "MemberBQTFLNGO",
                "betAmount": 600.00,
                "amount": 1491.00,
                "winTime": "2025-09-24 10:34:06",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062223jjaj.png"
            },
            {
                "type": "KoolBet",
                "typeName": "KoolBet",
                "userPhoto": "1",
                "nickName": "MemberBMWSYQMX",
                "betAmount": 288.00,
                "amount": 688.00,
                "winTime": "2025-09-24 10:34:02",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20250830170136ql3l.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "5",
                "nickName": "MemberQPEZLLNC",
                "betAmount": 100.00,
                "amount": 150.00,
                "winTime": "2025-09-24 10:33:59",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "5",
                "typeName": "5D 1 min",
                "userPhoto": "16",
                "nickName": "MemberCHFLAULP",
                "betAmount": 500.00,
                "amount": 980.00,
                "winTime": "2025-09-24 10:33:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "5",
                "typeName": "5D 1 min",
                "userPhoto": "14",
                "nickName": "MemberIEDHGAIS",
                "betAmount": 1900.00,
                "amount": 3724.00,
                "winTime": "2025-09-24 10:33:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "5",
                "nickName": "MemberTZYJDMCO",
                "betAmount": 384.16,
                "amount": 768.32,
                "winTime": "2025-09-24 10:33:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "5",
                "nickName": "MemberCCSFWZTB",
                "betAmount": 196.00,
                "amount": 392.00,
                "winTime": "2025-09-24 10:33:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "2",
                "nickName": "MemberXBAIIZCF",
                "betAmount": 800.00,
                "amount": 1736.00,
                "winTime": "2025-09-24 10:33:54",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "1",
                "nickName": "MemberRXWCYUFC",
                "betAmount": 270.00,
                "amount": 115.00,
                "winTime": "2025-09-24 10:33:38",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "5",
                "nickName": "MemberVDTOFQVH",
                "betAmount": 50.00,
                "amount": 130.00,
                "winTime": "2025-09-24 10:33:28",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "6",
                "nickName": "MemberEWAMAASV",
                "betAmount": 300.00,
                "amount": 600.00,
                "winTime": "2025-09-24 10:33:28",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "2",
                "nickName": "MemberVNWJSIWN",
                "betAmount": 1650.00,
                "amount": 200.00,
                "winTime": "2025-09-24 10:33:28",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "KoolBet",
                "typeName": "KoolBet",
                "userPhoto": "7",
                "nickName": "MemberMFTBZPXD",
                "betAmount": 62.00,
                "amount": 262.00,
                "winTime": "2025-09-24 10:33:26",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20250830170136ql3l.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "8",
                "nickName": "MemberUGDROHWA",
                "betAmount": 520.00,
                "amount": 400.00,
                "winTime": "2025-09-24 10:33:16",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "KoolBet",
                "typeName": "KoolBet",
                "userPhoto": "8",
                "nickName": "MemberQLJSOWGJ",
                "betAmount": 33.60,
                "amount": 153.60,
                "winTime": "2025-09-24 10:33:11",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20250830170136ql3l.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "4",
                "nickName": "MemberCSYFMUHB",
                "betAmount": 410.00,
                "amount": 600.00,
                "winTime": "2025-09-24 10:33:10",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "11",
                "nickName": "MemberKARYHCIZ",
                "betAmount": 650.00,
                "amount": 720.00,
                "winTime": "2025-09-24 10:33:10",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "6",
                "nickName": "MemberZZSXGCYK",
                "betAmount": 260.00,
                "amount": 180.00,
                "winTime": "2025-09-24 10:32:59",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "5",
                "nickName": "MemberOEYFNKHM",
                "betAmount": 330.00,
                "amount": 440.00,
                "winTime": "2025-09-24 10:32:57",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "8",
                "nickName": "MemberHGEGGBNF",
                "betAmount": 120.00,
                "amount": 220.00,
                "winTime": "2025-09-24 10:32:57",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "8",
                "nickName": "MemberVMTIPXOJ",
                "betAmount": 100.00,
                "amount": 220.00,
                "winTime": "2025-09-24 10:32:57",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "18",
                "nickName": "MemberLCTOKTQL",
                "betAmount": 40.00,
                "amount": 220.00,
                "winTime": "2025-09-24 10:32:57",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "9",
                "typeName": "K3 1 min",
                "userPhoto": "6",
                "nickName": "MemberPWZYHBDQ",
                "betAmount": 196.00,
                "amount": 392.00,
                "winTime": "2025-09-24 10:32:57",
                "showType": 9,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062111bt8e.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "8",
                "nickName": "MemberHWRGVNFO",
                "betAmount": 1400.00,
                "amount": 500.00,
                "winTime": "2025-09-24 10:32:45",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "KoolBet",
                "typeName": "KoolBet",
                "userPhoto": "7",
                "nickName": "MemberXLTZVNTQ",
                "betAmount": 39.60,
                "amount": 159.60,
                "winTime": "2025-09-24 10:32:31",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20250830170136ql3l.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "17",
                "nickName": "MemberRCZMPHYQ",
                "betAmount": 500.00,
                "amount": 992.00,
                "winTime": "2025-09-24 10:32:19",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "15",
                "nickName": "MemberDKPAOKOU",
                "betAmount": 200.00,
                "amount": 420.00,
                "winTime": "2025-09-24 10:32:16",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "19",
                "nickName": "MemberOWJWFEFQ",
                "betAmount": 550.00,
                "amount": 1100.00,
                "winTime": "2025-09-24 10:32:16",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "KoolBet",
                "typeName": "KoolBet",
                "userPhoto": "4",
                "nickName": "MemberMVCAXTCJ",
                "betAmount": 80.40,
                "amount": 200.40,
                "winTime": "2025-09-24 10:32:01",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20250830170136ql3l.png"
            },
            {
                "type": "5",
                "typeName": "5D 1 min",
                "userPhoto": "9",
                "nickName": "MemberQTXVSQFG",
                "betAmount": 1000.00,
                "amount": 1960.00,
                "winTime": "2025-09-24 10:31:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "18",
                "nickName": "MemberYUPYHPUX",
                "betAmount": 500.00,
                "amount": 992.00,
                "winTime": "2025-09-24 10:31:54",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "EVO_Video",
                "typeName": "EVO_Video",
                "userPhoto": "10",
                "nickName": "MemberAWOGWYLS",
                "betAmount": 2100.00,
                "amount": 150.00,
                "winTime": "2025-09-24 10:31:52",
                "showType": 1,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062454o17n.png"
            },
            {
                "type": "KoolBet",
                "typeName": "KoolBet",
                "userPhoto": "6",
                "nickName": "MemberQHMPMYNY",
                "betAmount": 46.80,
                "amount": 166.80,
                "winTime": "2025-09-24 10:31:40",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20250830170136ql3l.png"
            },
            {
                "type": "5",
                "typeName": "5D 1 min",
                "userPhoto": "16",
                "nickName": "MemberWGURECEN",
                "betAmount": 2000.00,
                "amount": 3920.00,
                "winTime": "2025-09-24 10:30:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "KoolBet",
                "typeName": "KoolBet",
                "userPhoto": "18",
                "nickName": "MemberCAYYLYTA",
                "betAmount": 90.00,
                "amount": 210.00,
                "winTime": "2025-09-24 10:30:48",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20250830170136ql3l.png"
            },
            {
                "type": "KoolBet",
                "typeName": "KoolBet",
                "userPhoto": "4",
                "nickName": "MemberIVFPTEDT",
                "betAmount": 42.00,
                "amount": 162.00,
                "winTime": "2025-09-24 10:30:21",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20250830170136ql3l.png"
            },
            {
                "type": "Card365",
                "typeName": "Card365",
                "userPhoto": "14",
                "nickName": "MemberQFRAKJLZ",
                "betAmount": 1261.00,
                "amount": 2561.00,
                "winTime": "2025-09-24 10:29:59",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062223jjaj.png"
            },
            {
                "type": "5",
                "typeName": "5D 1 min",
                "userPhoto": "5",
                "nickName": "MemberKRHOTZCG",
                "betAmount": 2000.00,
                "amount": 3920.00,
                "winTime": "2025-09-24 10:29:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "7",
                "typeName": "5D 5 min",
                "userPhoto": "4",
                "nickName": "MemberGVZJPNGJ",
                "betAmount": 459.00,
                "amount": 899.64,
                "winTime": "2025-09-24 10:29:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "KoolBet",
                "typeName": "KoolBet",
                "userPhoto": "7",
                "nickName": "MemberLNPZZDUA",
                "betAmount": 40.00,
                "amount": 140.00,
                "winTime": "2025-09-24 10:29:23",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20250830170136ql3l.png"
            },
            {
                "type": "KoolBet",
                "typeName": "KoolBet",
                "userPhoto": "2",
                "nickName": "MemberHPHKCXRU",
                "betAmount": 67.00,
                "amount": 167.00,
                "winTime": "2025-09-24 10:28:57",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20250830170136ql3l.png"
            },
            {
                "type": "5",
                "typeName": "5D 1 min",
                "userPhoto": "15",
                "nickName": "MemberRGAHPGUT",
                "betAmount": 100.00,
                "amount": 196.00,
                "winTime": "2025-09-24 10:28:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "5",
                "typeName": "5D 1 min",
                "userPhoto": "5",
                "nickName": "MemberNUOVQHTC",
                "betAmount": 2000.00,
                "amount": 3920.00,
                "winTime": "2025-09-24 10:28:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "KoolBet",
                "typeName": "KoolBet",
                "userPhoto": "12",
                "nickName": "MemberUKNNBDDB",
                "betAmount": 62.00,
                "amount": 162.00,
                "winTime": "2025-09-24 10:28:36",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20250830170136ql3l.png"
            },
            {
                "type": "KoolBet",
                "typeName": "KoolBet",
                "userPhoto": "2",
                "nickName": "MemberWLUZZGPL",
                "betAmount": 63.00,
                "amount": 163.00,
                "winTime": "2025-09-24 10:28:00",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20250830170136ql3l.png"
            },
            {
                "type": "KoolBet",
                "typeName": "KoolBet",
                "userPhoto": "13",
                "nickName": "MemberBAXCUHYG",
                "betAmount": 48.00,
                "amount": 148.00,
                "winTime": "2025-09-24 10:27:25",
                "showType": 3,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20250830170136ql3l.png"
            },
            {
                "type": "5",
                "typeName": "5D 1 min",
                "userPhoto": "13",
                "nickName": "MemberPGBMCSWN",
                "betAmount": 100.00,
                "amount": 196.00,
                "winTime": "2025-09-24 10:26:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "7",
                "typeName": "5D 5 min",
                "userPhoto": "14",
                "nickName": "MemberVMTAGYWJ",
                "betAmount": 707.00,
                "amount": 1385.72,
                "winTime": "2025-09-24 10:24:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "5",
                "typeName": "5D 1 min",
                "userPhoto": "3",
                "nickName": "MemberDJQWVQOI",
                "betAmount": 100.00,
                "amount": 196.00,
                "winTime": "2025-09-24 10:23:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "5",
                "typeName": "5D 1 min",
                "userPhoto": "7",
                "nickName": "MemberJHPYNCWP",
                "betAmount": 220.00,
                "amount": 431.20,
                "winTime": "2025-09-24 10:19:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "6",
                "nickName": "MemberQQIPBXRO",
                "betAmount": 100.00,
                "amount": 196.00,
                "winTime": "2025-09-24 10:19:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "5",
                "typeName": "5D 1 min",
                "userPhoto": "15",
                "nickName": "MemberLDZYAJHH",
                "betAmount": 180.00,
                "amount": 352.80,
                "winTime": "2025-09-24 10:18:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "7",
                "nickName": "MemberAQHMLIYV",
                "betAmount": 100.00,
                "amount": 196.00,
                "winTime": "2025-09-24 10:10:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "5",
                "typeName": "5D 1 min",
                "userPhoto": "18",
                "nickName": "MemberGWMGFBBY",
                "betAmount": 400.00,
                "amount": 784.00,
                "winTime": "2025-09-24 10:09:57",
                "showType": 7,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062118e9kt.png"
            },
            {
                "type": "IM",
                "typeName": "IM",
                "userPhoto": "1",
                "nickName": "MemberFQDLOCFD",
                "betAmount": 347.00,
                "amount": 1154.26,
                "winTime": "2025-09-24 10:02:16",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062216iru9.png"
            },
            {
                "type": "SaBa",
                "typeName": "SaBa",
                "userPhoto": "19",
                "nickName": "MemberDKQBKVUM",
                "betAmount": 200.00,
                "amount": 860.00,
                "winTime": "2025-09-24 09:58:22",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062311bv5e.png"
            },
            {
                "type": "SaBa",
                "typeName": "SaBa",
                "userPhoto": "8",
                "nickName": "MemberWLRPSOVM",
                "betAmount": 429.25,
                "amount": 934.25,
                "winTime": "2025-09-24 09:45:10",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062311bv5e.png"
            },
            {
                "type": "SaBa",
                "typeName": "SaBa",
                "userPhoto": "8",
                "nickName": "MemberACMZAQMT",
                "betAmount": 3070.40,
                "amount": 6302.40,
                "winTime": "2025-09-24 09:39:34",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062311bv5e.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "11",
                "nickName": "MemberHTEQYFFD",
                "betAmount": 100.00,
                "amount": 196.00,
                "winTime": "2025-09-24 09:33:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "SaBa",
                "typeName": "SaBa",
                "userPhoto": "6",
                "nickName": "MemberYFRJOBFF",
                "betAmount": 180.00,
                "amount": 380.00,
                "winTime": "2025-09-24 09:26:33",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062311bv5e.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "1",
                "nickName": "MemberUZLIFPJF",
                "betAmount": 100.00,
                "amount": 196.00,
                "winTime": "2025-09-24 09:24:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "SaBa",
                "typeName": "SaBa",
                "userPhoto": "11",
                "nickName": "MemberWQUHTYAU",
                "betAmount": 425.00,
                "amount": 925.00,
                "winTime": "2025-09-24 09:22:55",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062311bv5e.png"
            },
            {
                "type": "SaBa",
                "typeName": "SaBa",
                "userPhoto": "12",
                "nickName": "MemberHRCRQUXS",
                "betAmount": 415.00,
                "amount": 915.00,
                "winTime": "2025-09-24 09:09:59",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062311bv5e.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "2",
                "nickName": "MemberPOOXQMQT",
                "betAmount": 100.00,
                "amount": 196.00,
                "winTime": "2025-09-24 08:57:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "6",
                "nickName": "MemberCIJEUIUR",
                "betAmount": 100.00,
                "amount": 196.00,
                "winTime": "2025-09-24 08:56:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "18",
                "nickName": "MemberEVBVBFAV",
                "betAmount": 19.00,
                "amount": 182.47,
                "winTime": "2025-09-24 08:52:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "10",
                "nickName": "MemberMINPTPUL",
                "betAmount": 75.00,
                "amount": 147.00,
                "winTime": "2025-09-24 08:43:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "15",
                "nickName": "MemberMARCXTMO",
                "betAmount": 325.00,
                "amount": 637.00,
                "winTime": "2025-09-24 08:32:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "5",
                "nickName": "MemberPJVHYFQL",
                "betAmount": 277.00,
                "amount": 542.92,
                "winTime": "2025-09-24 08:32:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "13",
                "nickName": "MemberPIGAMIKL",
                "betAmount": 49.00,
                "amount": 470.59,
                "winTime": "2025-09-24 08:25:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "8",
                "nickName": "MemberDSEPAZOZ",
                "betAmount": 691.00,
                "amount": 1354.36,
                "winTime": "2025-09-24 08:24:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "5",
                "nickName": "MemberIBIZANYZ",
                "betAmount": 100.00,
                "amount": 196.00,
                "winTime": "2025-09-24 08:24:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "11",
                "nickName": "MemberCRUJOQMY",
                "betAmount": 20.00,
                "amount": 192.08,
                "winTime": "2025-09-24 08:23:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "13",
                "nickName": "MemberTQMBDVAW",
                "betAmount": 20.00,
                "amount": 192.08,
                "winTime": "2025-09-24 08:23:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "18",
                "nickName": "MemberEYZGEFAZ",
                "betAmount": 100.00,
                "amount": 196.00,
                "winTime": "2025-09-24 08:22:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "14",
                "nickName": "MemberJITTPPWF",
                "betAmount": 200.00,
                "amount": 392.00,
                "winTime": "2025-09-24 08:21:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "10",
                "nickName": "MemberOETWZXEC",
                "betAmount": 20.00,
                "amount": 192.08,
                "winTime": "2025-09-24 08:20:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "14",
                "nickName": "MemberLCFRPVQP",
                "betAmount": 20.00,
                "amount": 192.08,
                "winTime": "2025-09-24 08:19:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "SaBa",
                "typeName": "SaBa",
                "userPhoto": "14",
                "nickName": "MemberMEKCQBRB",
                "betAmount": 1104.00,
                "amount": 2304.00,
                "winTime": "2025-09-24 08:18:05",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062311bv5e.png"
            },
            {
                "type": "IM",
                "typeName": "IM",
                "userPhoto": "9",
                "nickName": "MemberSJFGZDEE",
                "betAmount": 50.00,
                "amount": 222.00,
                "winTime": "2025-09-24 08:11:01",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062216iru9.png"
            },
            {
                "type": "SaBa",
                "typeName": "SaBa",
                "userPhoto": "8",
                "nickName": "MemberLILLQYBE",
                "betAmount": 1425.00,
                "amount": 2925.00,
                "winTime": "2025-09-24 08:09:03",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062311bv5e.png"
            },
            {
                "type": "SaBa",
                "typeName": "SaBa",
                "userPhoto": "17",
                "nickName": "MemberAPHVGIPN",
                "betAmount": 570.00,
                "amount": 1170.00,
                "winTime": "2025-09-24 08:09:03",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062311bv5e.png"
            },
            {
                "type": "17",
                "typeName": "Moto Racing",
                "userPhoto": "8",
                "nickName": "MemberBVJYYIEP",
                "betAmount": 100.00,
                "amount": 196.00,
                "winTime": "2025-09-24 08:01:55",
                "showType": 11,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/lotterycategory/lotterycategory_20240110062051do1k.png"
            },
            {
                "type": "SaBa",
                "typeName": "SaBa",
                "userPhoto": "4",
                "nickName": "MemberFVPNAOWB",
                "betAmount": 440.00,
                "amount": 940.00,
                "winTime": "2025-09-24 07:53:15",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062311bv5e.png"
            },
            {
                "type": "SaBa",
                "typeName": "SaBa",
                "userPhoto": "5",
                "nickName": "MemberGSCZKHLK",
                "betAmount": 500.00,
                "amount": 1170.00,
                "winTime": "2025-09-24 07:30:44",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062311bv5e.png"
            },
            {
                "type": "IM",
                "typeName": "IM",
                "userPhoto": "17",
                "nickName": "MemberSDKYPIME",
                "betAmount": 50.00,
                "amount": 104.00,
                "winTime": "2025-09-24 07:27:30",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110062216iru9.png"
            },
            {
                "type": "Wickets9",
                "typeName": "Wickets9",
                "userPhoto": "11",
                "nickName": "MemberIYHNEOMV",
                "betAmount": 0.00,
                "amount": 386.00,
                "winTime": "2025-09-24 07:07:50",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110204047s9qi.png"
            },
            {
                "type": "Wickets9",
                "typeName": "Wickets9",
                "userPhoto": "10",
                "nickName": "MemberJWEVZJFM",
                "betAmount": 0.00,
                "amount": 149.00,
                "winTime": "2025-09-24 07:06:57",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110204047s9qi.png"
            },
            {
                "type": "Wickets9",
                "typeName": "Wickets9",
                "userPhoto": "12",
                "nickName": "MemberKKEBOLNF",
                "betAmount": 0.00,
                "amount": 700.00,
                "winTime": "2025-09-24 06:48:04",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110204047s9qi.png"
            },
            {
                "type": "Wickets9",
                "typeName": "Wickets9",
                "userPhoto": "19",
                "nickName": "MemberXYFAUUWM",
                "betAmount": 0.00,
                "amount": 552.60,
                "winTime": "2025-09-24 06:44:28",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110204047s9qi.png"
            },
            {
                "type": "Wickets9",
                "typeName": "Wickets9",
                "userPhoto": "7",
                "nickName": "MemberFFUFTBEX",
                "betAmount": 0.00,
                "amount": 1572.57,
                "winTime": "2025-09-24 06:44:28",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110204047s9qi.png"
            },
            {
                "type": "Wickets9",
                "typeName": "Wickets9",
                "userPhoto": "16",
                "nickName": "MemberUDLPMQXF",
                "betAmount": 0.00,
                "amount": 5000.00,
                "winTime": "2025-09-24 06:01:00",
                "showType": 2,
                "imgUrl": "https://ossimg.bdgadminbdg.com/IndiaBDG/vendorlogo/vendorlogo_20240110204047s9qi.png"
            }
        ],
					"penarikanList": [
					  {
						"userPhoto": "14",
						"nickName": "MemberFDJPDKTS",
						"price": 5591121480,
						"time": "2024-05-07",
						"typeName": "Penarikan",
						"winTime": "5/7/2024 12:00:00 AM"
					  },
					  {
						"userPhoto": "7",
						"nickName": "MemberLKYYNMEE",
						"price": 4208908308.08,
						"time": "2024-05-07",
						"typeName": "Penarikan",
						"winTime": "5/7/2024 12:00:00 AM"
					  },
					  {
						"userPhoto": "3",
						"nickName": "MemberMQKQDSXZ",
						"price": 1697295314.12,
						"time": "2024-05-07",
						"typeName": "Penarikan",
						"winTime": "5/7/2024 12:00:00 AM"
					  },
					  {
						"userPhoto": "8",
						"nickName": "MemberZMKFGFTD",
						"price": 1652492170,
						"time": "2024-05-07",
						"typeName": "Penarikan",
						"winTime": "5/7/2024 12:00:00 AM"
					  },
					  {
						"userPhoto": "13",
						"nickName": "MemberFTKMDCVL",
						"price": 1257358919.88,
						"time": "2024-05-07",
						"typeName": "Penarikan",
						"winTime": "5/7/2024 12:00:00 AM"
					  },
					  {
						"userPhoto": "15",
						"nickName": "MemberFDJPDKTS",
						"price": 887596587,
						"time": "2024-05-07",
						"typeName": "Penarikan",
						"winTime": "5/7/2024 12:00:00 AM"
					  },
					  {
						"userPhoto": 16,
						"nickName": "MemberLKYYNMEE",
						"price": 558965874.08,
						"time": "2024-05-07",
						"typeName": "Penarikan",
						"winTime": "5/7/2024 12:00:00 AM"
					  },
					  {
						"userPhoto": "17",
						"nickName": "MemberMQKQDSXZ",
						"price": 26584795.12,
						"time": "2024-05-07",
						"typeName": "Penarikan",
						"winTime": "5/7/2024 12:00:00 AM"
					  },
					  {
						"userPhoto": "18",
						"nickName": "MemberZMKFGFTD",
						"price": 3659824,
						"time": "2024-05-07",
						"typeName": "Penarikan",
						"winTime": "5/7/2024 12:00:00 AM"
					  },
					  {
						"userPhoto": "19",
						"nickName": "MemberFTKMDCVL",
						"price": 156254.88,
						"time": "2024-05-07",
						"typeName": "Penarikan",
						"winTime": "5/7/2024 12:00:00 AM"
					  }
					]
				  },
				  "code": 0,
				  "msg": "Succeed",
				  "msgCode": 0,
				  "serviceNowTime": "$shnunc"
				}';
			}
			else{
				$res['code'] = 5;
				$res['msg'] = 'Wrong signature';
				$res['msgCode'] = 3;
				http_response_code(200);
				echo json_encode($res);
			}
		}
		else{
			$res['code'] = 7;
			$res['msg'] = 'Param is Invalid';
			$res['msgCode'] = 6;
			http_response_code(200);
			echo json_encode($res);
		}		
	} else {		
		http_response_code(405);
		echo json_encode($res);
	}	
?>