<?php 
	include "../../conn.php";
	include "../../functions2.php";
	
	header('Content-Type: application/json; charset=utf-8');
	header('Strict-Transport-Security: max-age=31536000');
	header('Access-Control-Allow-Headers: Origin, X-Requested-With, Content-Type, Accept, Authorization');
	header('Access-Control-Allow-Credentials: true');
	$origin = isset($_SERVER['HTTP_ORIGIN']) ? $_SERVER['HTTP_ORIGIN'] : '';
	header('Access-Control-Allow-Origin: ' . $origin);
	header('vary: Origin');
	
	date_default_timezone_set("Asia/Kolkata");
	$shnunc = date("Y-m-d H:i:s");
	$res = [
		'code' => 11,
		'msg' => 'Method not allowed',
		'msgCode' => 12,
		'serviceNowTime' => $shnunc,
	];
	$shonubody = file_get_contents("php://input");
	$shonupost = json_decode($shonubody, true);
	
	if ($_SERVER['REQUEST_METHOD'] != 'GET') {
		if (isset($shonupost['language']) || isset($shonupost['payTypeId']) || isset($shonupost['payid']) || isset($shonupost['random']) || isset($shonupost['signature']) || isset($shonupost['timestamp'])) {
			$language = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['language']));
			$payTypeId = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['payTypeId']));
			$payid = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['payid']));
			$random = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['random']));
			$signature = htmlspecialchars(mysqli_real_escape_string($conn, $shonupost['signature']));
			$shonustr = '{"language":'.$language.',"payTypeId":'.$payTypeId.',"payid":'.$payid.',"random":"'.$random.'"}';
			$shonusign = strtoupper(md5($shonustr));
			if($shonusign){
				$bearer = explode(" ", $_SERVER['HTTP_AUTHORIZATION']);
				$author = $bearer[1];				
				$is_jwt_valid = is_jwt_valid($author);
				$data_auth = json_decode($is_jwt_valid, 1);
				if($data_auth['status'] === 'Success') {
					$sesquery = "SELECT akshinak
					  FROM shonu_subjects
					  WHERE akshinak = '$author'";
					$sesresult=$conn->query($sesquery);
					$sesnum = mysqli_num_rows($sesresult);
					if($sesnum == 1){
						$sites = 'https://mafiyaclub.com';
						
						if ($payid == 11) {
                            $data["rechargetypelist"]["0"]["payTypeID"] = (int)"2191";
                            $data["rechargetypelist"]["0"]["payID"] = (int)"11";
                            $data["rechargetypelist"]["0"]["payName"] = "BEP-20";
                            $data["rechargetypelist"]["0"]["paySysName"] = "825";
                            $data["rechargetypelist"]["0"]["miniPrice"] = (int)"500";
                            $data["rechargetypelist"]["0"]["maxPrice"] = (int)"50000";
                            $data["rechargetypelist"]["0"]["scope"] = "50|100|250|500|1000";
                            $data["rechargetypelist"]["0"]["paySendUrl"] = $sites."/pay/wepay";
                            $data["rechargetypelist"]["0"]["parameters"] = '';
                            $data["rechargetypelist"]["0"]["startTime"] = "01:00";
                            $data["rechargetypelist"]["0"]["endTime"] = "23:00";
                            $data["rechargetypelist"]["0"]["rechargeRifts"] = (float)"0.00";
                            $data["rechargetypelist"]["0"]["c2cUnitAmount"] = null;
                        
                            $data["rechargetypelist"]["0"]["quickConfig"] = "";
                            $data["rechargetypelist"]["0"]["quickConfigList"] = [
                                 ["rechargeAmount" => 50.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 100.0, "giftAmount" => 0.0],
                                ["rechargeAmount" => 150.0, "giftAmount" => 0.0],
                                ["rechargeAmount" => 1000.0, "giftAmount" => 0.0],
                                ["rechargeAmount" => 3000.0, "giftAmount" => 0.0],
                                ["rechargeAmount" => 5000.0, "giftAmount" => 0.0],
                             ];
                            $data["rechargetypelist"]["0"]["random"] = 0.758493;
                            $data["rechargetypelist"]["0"]["sort"] = 95000;
                                           
                            $data["rechargetypelist"]["1"]["payTypeID"] = (int)"2192";
                            $data["rechargetypelist"]["1"]["payID"] = (int)"11";
                            $data["rechargetypelist"]["1"]["payName"] = "BEP-20 (2)";
                            $data["rechargetypelist"]["1"]["paySysName"] = "826";
                            $data["rechargetypelist"]["1"]["miniPrice"] = (int)"500";
                            $data["rechargetypelist"]["1"]["maxPrice"] = (int)"50000";
                            $data["rechargetypelist"]["1"]["scope"] = "50|100|250|500|1000";
                            $data["rechargetypelist"]["1"]["paySendUrl"] = $sites."/pay/wepay";
                            $data["rechargetypelist"]["1"]["parameters"] = '';
                            $data["rechargetypelist"]["1"]["startTime"] = "01:00";
                            $data["rechargetypelist"]["1"]["endTime"] = "23:00";
                            $data["rechargetypelist"]["1"]["rechargeRifts"] = (float)"0.00";
                            $data["rechargetypelist"]["1"]["c2cUnitAmount"] = null;
                        
                            $data["rechargetypelist"]["1"]["quickConfig"] = "";
                            $data["rechargetypelist"]["1"]["quickConfigList"] = [
                                 ["rechargeAmount" => 500.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 1000.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 1500.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 10000.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 30000.0, "giftAmount" => 0.0],
                                ["rechargeAmount" => 50000.0, "giftAmount" => 00.0],
                             ];
                            $data["rechargetypelist"]["2"]["random"] = 0.758493;
                            $data["rechargetypelist"]["2"]["sort"] = 95000;
                            
                            $data["rechargetypelist"]["2"]["payTypeID"] = (int)"2193";
                            $data["rechargetypelist"]["2"]["payID"] = (int)"11";
                            $data["rechargetypelist"]["2"]["payName"] = "BEP-20 (3)";
                            $data["rechargetypelist"]["2"]["paySysName"] = "827";
                            $data["rechargetypelist"]["2"]["miniPrice"] = (int)"500";
                            $data["rechargetypelist"]["2"]["maxPrice"] = (int)"50000";
                            $data["rechargetypelist"]["2"]["scope"] = "50|100|250|500|1000";
                            $data["rechargetypelist"]["2"]["paySendUrl"] = $sites."/pay/wepay";
                            $data["rechargetypelist"]["2"]["parameters"] = '';
                            $data["rechargetypelist"]["2"]["startTime"] = "01:00";
                            $data["rechargetypelist"]["2"]["endTime"] = "23:00";
                            $data["rechargetypelist"]["2"]["rechargeRifts"] = (float)"0.00";
                            $data["rechargetypelist"]["2"]["c2cUnitAmount"] = null;
                        
                            $data["rechargetypelist"]["2"]["quickConfig"] = "";
                            $data["rechargetypelist"]["2"]["quickConfigList"] = [
                                 ["rechargeAmount" => 500.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 1000.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 1500.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 10000.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 30000.0, "giftAmount" => 0.0],
                                ["rechargeAmount" => 50000.0, "giftAmount" => 00.0],
                             ];
                            $data["rechargetypelist"]["2"]["random"] = 0.758493;
                            $data["rechargetypelist"]["2"]["sort"] = 95000;
                            
                            $data["rechargetypelist"]["3"]["payTypeID"] = (int)"2194";
                            $data["rechargetypelist"]["3"]["payID"] = (int)"11";
                            $data["rechargetypelist"]["3"]["payName"] = "BEP-20 (4)";
                            $data["rechargetypelist"]["3"]["paySysName"] = "828";
                            $data["rechargetypelist"]["3"]["miniPrice"] = (int)"500";
                            $data["rechargetypelist"]["3"]["maxPrice"] = (int)"50000";
                            $data["rechargetypelist"]["3"]["scope"] = "50|100|250|500|1000";
                            $data["rechargetypelist"]["3"]["paySendUrl"] = $sites."/pay/wepay";
                            $data["rechargetypelist"]["3"]["parameters"] = '';
                            $data["rechargetypelist"]["3"]["startTime"] = "01:00";
                            $data["rechargetypelist"]["3"]["endTime"] = "23:00";
                            $data["rechargetypelist"]["3"]["rechargeRifts"] = (float)"0.00";
                            $data["rechargetypelist"]["3"]["c2cUnitAmount"] = null;
                        
                            $data["rechargetypelist"]["3"]["quickConfig"] = "";
                            $data["rechargetypelist"]["3"]["quickConfigList"] = [
                                 ["rechargeAmount" => 500.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 1000.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 1500.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 10000.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 30000.0, "giftAmount" => 0.0],
                                ["rechargeAmount" => 50000.0, "giftAmount" => 00.0],
                             ];
                            $data["rechargetypelist"]["3"]["random"] = 0.758493;
                            $data["rechargetypelist"]["3"]["sort"] = 95000;
                            
                            $data["rechargetypelist"]["4"]["payTypeID"] = (int)"2195";
                            $data["rechargetypelist"]["4"]["payID"] = (int)"11";
                            $data["rechargetypelist"]["4"]["payName"] = "BEP-20 (5)";
                            $data["rechargetypelist"]["4"]["paySysName"] = "829";
                            $data["rechargetypelist"]["4"]["miniPrice"] = (int)"500";
                            $data["rechargetypelist"]["4"]["maxPrice"] = (int)"50000";
                            $data["rechargetypelist"]["4"]["scope"] = "50|100|250|500|1000";
                            $data["rechargetypelist"]["4"]["paySendUrl"] = $sites."/pay/wepay";
                            $data["rechargetypelist"]["4"]["parameters"] = '';
                            $data["rechargetypelist"]["4"]["startTime"] = "01:00";
                            $data["rechargetypelist"]["4"]["endTime"] = "23:00";
                            $data["rechargetypelist"]["4"]["rechargeRifts"] = (float)"0.00";
                            $data["rechargetypelist"]["4"]["c2cUnitAmount"] = null;
                        
                            $data["rechargetypelist"]["4"]["quickConfig"] = "";
                            $data["rechargetypelist"]["4"]["quickConfigList"] = [
                                 ["rechargeAmount" => 500.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 1000.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 1500.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 10000.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 30000.0, "giftAmount" => 0.0],
                                ["rechargeAmount" => 50000.0, "giftAmount" => 00.0],
                             ];
                            $data["rechargetypelist"]["4"]["random"] = 0.758493;
                            $data["rechargetypelist"]["4"]["sort"] = 95000;
                            
                            $data["rechargetypelist"]["5"]["payTypeID"] = (int)"2196";
                            $data["rechargetypelist"]["5"]["payID"] = (int)"11";
                            $data["rechargetypelist"]["5"]["payName"] = "BEP-20 (6)";
                            $data["rechargetypelist"]["5"]["paySysName"] = "830";
                            $data["rechargetypelist"]["5"]["miniPrice"] = (int)"500";
                            $data["rechargetypelist"]["5"]["maxPrice"] = (int)"50000";
                            $data["rechargetypelist"]["5"]["scope"] = "50|100|250|500|1000";
                            $data["rechargetypelist"]["5"]["paySendUrl"] = $sites."/pay/wepay";
                            $data["rechargetypelist"]["5"]["parameters"] = '';
                            $data["rechargetypelist"]["5"]["startTime"] = "01:00";
                            $data["rechargetypelist"]["5"]["endTime"] = "23:00";
                            $data["rechargetypelist"]["5"]["rechargeRifts"] = (float)"0.00";
                            $data["rechargetypelist"]["5"]["c2cUnitAmount"] = null;
                        
                            $data["rechargetypelist"]["5"]["quickConfig"] = "";
                            $data["rechargetypelist"]["5"]["quickConfigList"] = [
                                 ["rechargeAmount" => 500.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 1000.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 1500.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 10000.0, "giftAmount" => 00.0],
                                ["rechargeAmount" => 30000.0, "giftAmount" => 0.0],
                                ["rechargeAmount" => 50000.0, "giftAmount" => 00.0],
                             ];
                            $data["rechargetypelist"]["5"]["random"] = 0.758493;
                            $data["rechargetypelist"]["5"]["sort"] = 95000;
                        
                        }
						$data['banklist'] = null;
						$data['localUsdtlist'] = null;
						$data['thirdPayBankList'] = null;
												
						$res['data'] = $data;
						$res['code'] = 0;
						$res['msg'] = 'Succeed';
						$res['msgCode'] = 0;
						http_response_code(200);
						echo json_encode($res);					
					}
					else{
						$res['code'] = 4;
						$res['msg'] = 'No operation permission';
						$res['msgCode'] = 2;
						http_response_code(401);
						echo json_encode($res);
					}					
				}
				else{					
					$res['code'] = 4;
					$res['msg'] = 'No operation permission';
					$res['msgCode'] = 2;
					http_response_code(401);
					echo json_encode($res);					
				}
			}
			else{
				$res['code'] = 5;
				$res['msg'] = 'Wrong signature';
				$res['msgCode'] = 3;
				http_response_code(200);
				echo json_encode($res);				
			}
		}
		else{
			$res['code'] = 7;
			$res['msg'] = 'Param is Invalid';
			$res['msgCode'] = 6;
			http_response_code(200);
			echo json_encode($res);			
		}		
	} else {		
		http_response_code(405);
		echo json_encode($res);
	}
?>